Attribute VB_Name = "mdCreateBlend"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Function CreateBlend(edges As Object, chamfer As Boolean, blendType As Long, values, params, blendName As String)

'Convenience Function to Blend the selected edges

'Get the ProDESKTOP Application Object
GetApplicationObject

'Get the Active PartDocument
Dim Part As PartDocument
Set Part = app.GetActiveDoc

'Continue only if Part is available
If Part Is Nothing Then
   Set CreateBlend = Nothing
   Exit Function
End If

'perform operation to create blend
Dim blend As aOperation
Set blend = app.GetClass("Blend").CreateBlend(Part.GetDesign, edges, chamfer, blendType, values, params)
If Not blend Is Nothing Then
    blend.SetName blendName
    Part.UpdateDesign
End If

Set CreateBlend = blend

End Function

